/*
 * Decompiled with CFR 0.152.
 */
package com.terraforged.mod.featuremanager.template;

import java.util.function.BiPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.feature.TreeFeature;

public class BlockUtils {
    public static boolean isAir(IBlockReader world, BlockPos pos) {
        return BlockUtils.isAir(world.func_180495_p(pos), world, pos);
    }

    public static boolean isAir(BlockState state, IBlockReader world, BlockPos pos) {
        return state.func_177230_c().isAir(state, world, pos);
    }

    public static boolean isSoil(IWorld world, BlockPos pos) {
        return TreeFeature.func_227250_b_((Block)world.func_180495_p(pos).func_177230_c());
    }

    public static boolean isLeavesOrLogs(BlockState state) {
        return BlockTags.field_200031_h.func_230235_a_((Object)state.func_177230_c()) || BlockTags.field_206952_E.func_230235_a_((Object)state.func_177230_c());
    }

    public static boolean isVegetation(IWorld world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_235714_a_((ITag)BlockTags.field_200030_g) || state.func_235714_a_((ITag)BlockTags.field_226149_I_) || state.func_203425_a((Block)Blocks.field_150395_bd.delegate.get());
    }

    public static boolean canTreeReplace(IWorld world, BlockPos pos) {
        return TreeFeature.func_236412_d_((IWorldGenerationBaseReader)world, (BlockPos)pos) || BlockUtils.isVegetation(world, pos);
    }

    public static boolean isSolid(IBlockReader reader, BlockPos pos) {
        BlockState state = reader.func_180495_p(pos);
        return BlockUtils.isSolid(state, reader, pos);
    }

    public static boolean isSolid(BlockState state, IBlockReader reader, BlockPos pos) {
        return state.func_200132_m() || !state.func_196957_g(reader, pos, PathType.LAND);
    }

    public static boolean isSoilOrRock(IWorld world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return TreeFeature.func_227250_b_((Block)block) || BlockTags.field_242172_aH.func_230235_a_((Object)block);
    }

    public static boolean isClearOverhead(IWorld world, BlockPos pos, int height, BiPredicate<IWorld, BlockPos> predicate) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        int max = Math.min(world.func_217301_I() - 1, pos.func_177956_o() + height);
        for (int y = pos.func_177956_o(); y < max; ++y) {
            mutable.func_181079_c(pos.func_177958_n(), y, pos.func_177952_p());
            if (predicate.test(world, (BlockPos)mutable)) continue;
            return false;
        }
        return true;
    }
}

